/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.util.ImageUtils;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class TextureReader
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<NativeImage> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        ResourceLocation rl = ResourceLocation.m_135822_((String)locationSource.path, (char)':');
        ResourceLocation out_rl = new ResourceLocation(rl.m_135827_(), "textures/" + rl.m_135815_() + ".png");
        return () -> {
            try {
                return ImageUtils.getImage(out_rl);
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.debug("Issue loading texture: {}", (Object)rl);
                return null;
            }
        };
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        public String path;
    }
}

